
/*****************************************************************************
*
* Copyright 2019 NXP
* All Rights Reserved
*
*****************************************************************************
*
* THIS SOFTWARE IS PROVIDED BY NXP "AS IS" AND ANY EXPRESSED OR
* IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
* OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
* IN NO EVENT SHALL NXP OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
* INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
* (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
* SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
* HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
* STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
* IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
* THE POSSIBILITY OF SUCH DAMAGE.
*
****************************************************************************/

/*!*********************************************************************************
*  @file    roiicp_graph.hpp
*  @brief   ACF graph
***********************************************************************************/

#ifndef ROIICPGRAPH_HPP
#define ROIICPGRAPH_HPP

#include <acf_graph.hpp>

#ifdef APEX2_EMULATE
#include "acf_lib.hpp"
using namespace APEX2;
#endif

#include "roiicp_graph_names.h"

#include "gauss_5x5_acf.h"

class RoiIcpGraph: public ACF_Graph
{
public:
  RoiIcpGraph() : ACF_Graph()
  {
    XREGISTER_ACF_KERNEL(GAUSS_5x5_K);
  }

  void Create()
  {
    //set identifier for graph
    SetIdentifier("RoiIcpGraph");

    //add kernels
    const std::string apu_gauss_5x5_0("apu_gauss_5x5_0");
    AddKernel(apu_gauss_5x5_0, GAUSS_5x5_KN);

    //add graph ports
    AddInputPort(GR_INPUT0_IN);
    AddOutputPort(GR_OUTPUT0_OUT);

    //specify connections
    Connect(GraphPort(GR_INPUT0_IN), KernelPort(apu_gauss_5x5_0, GAUSS_5x5_KN_IN));
    Connect(KernelPort(apu_gauss_5x5_0, GAUSS_5x5_KN_OUT), GraphPort(GR_OUTPUT0_OUT));
  }
};

#endif /* ROIICPGRAPH_HPP */
